/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import java.util.List;
import net.adventurez.entity.SpellCastingEntity;
import net.adventurez.entity.WitherPuppetEntity;
import net.adventurez.init.EffectInit;
import net.adventurez.init.EntityInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class NecromancerEntity
extends SpellCastingEntity {
    public NecromancerEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
        this.f_21364_ = 15;
    }

    public static AttributeSupplier.Builder createNecromancerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 45.0).m_22268_(Attributes.f_22279_, 0.34).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22282_, 0.1).m_22268_(Attributes.f_22277_, 38.0);
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtTargetGoalNecro());
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new SummonPuppetGoal());
        this.f_21345_.m_25352_(5, (Goal)new MagicWitheringGoal());
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.9));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f, 1.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{WitherPuppetEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{WitherSkeleton.class}));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
    }

    public static boolean canSpawn(EntityType<NecromancerEntity> type, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return NecromancerEntity.m_219013_(type, (ServerLevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)pos, (RandomSource)random) && world.m_8055_(pos.m_7495_()).equals(Blocks.f_50197_.m_49966_()) && world.m_6443_(NecromancerEntity.class, new AABB(pos).m_82400_(60.0), EntitySelector.f_20408_).isEmpty() || spawnReason == MobSpawnType.SPAWNER;
    }

    @Override
    public void m_8024_() {
        int invisibleChance;
        super.m_8024_();
        if (this.isSpellcasting() && this.spellTicks == 3 && (invisibleChance = this.m_9236_().m_213780_().m_188503_(5)) == 0) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 100));
            if (this.m_9236_().m_5776_()) {
                for (int i = 0; i < 10; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return effect.m_19544_() == MobEffects.f_19615_ ? false : super.m_7301_(effect);
    }

    public int m_5792_() {
        return 1;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12559_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_11866_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11864_;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12562_, 0.5f, 0.7f);
    }

    @Override
    public SoundEvent getCastSpellSound() {
        return SoundEvents.f_11862_;
    }

    public boolean m_7307_(Entity other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (super.m_7307_(other)) {
            return true;
        }
        if (other instanceof WitherPuppetEntity) {
            return this.m_7307_((Entity)((WitherPuppetEntity)other).getOwner());
        }
        return false;
    }

    private boolean arePuppetsNearby() {
        List list = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(40.0), EntitySelector.f_20408_);
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                LivingEntity entity = (LivingEntity)list.get(i);
                if (entity.m_6095_() != EntityInit.WITHER_PUPPET) continue;
                return true;
            }
        }
        return false;
    }

    private class LookAtTargetGoalNecro
    extends SpellCastingEntity.LookAtTargetGoal {
        private LookAtTargetGoalNecro() {
            super(NecromancerEntity.this);
        }

        @Override
        public void m_8037_() {
            if (NecromancerEntity.this.m_5448_() != null) {
                NecromancerEntity.this.m_21563_().m_24960_((Entity)NecromancerEntity.this.m_5448_(), (float)NecromancerEntity.this.m_8085_(), (float)NecromancerEntity.this.m_8132_());
            }
        }
    }

    private class SummonPuppetGoal
    extends SpellCastingEntity.CastSpellGoal {
        private final TargetingConditions CLOSE_PUPPET_PREDICATE;

        private SummonPuppetGoal() {
            super(NecromancerEntity.this);
            this.CLOSE_PUPPET_PREDICATE = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_().m_26893_();
        }

        @Override
        public boolean m_8036_() {
            if (!super.m_8036_() || NecromancerEntity.this.arePuppetsNearby()) {
                return false;
            }
            int i = NecromancerEntity.this.m_9236_().m_45971_(WitherPuppetEntity.class, this.CLOSE_PUPPET_PREDICATE, (LivingEntity)NecromancerEntity.this, NecromancerEntity.this.m_20191_().m_82400_(16.0)).size();
            return NecromancerEntity.this.f_19796_.m_188503_(8) + 1 > i;
        }

        @Override
        public int getSpellTicks() {
            return 100;
        }

        @Override
        public int startTimeDelay() {
            return 340;
        }

        @Override
        public void castSpell() {
            ServerLevel serverWorld = (ServerLevel)NecromancerEntity.this.m_9236_();
            int spellCount = 0;
            for (int i = 0; i < 20; ++i) {
                BlockPos blockPos = NecromancerEntity.this.m_20183_().m_7918_(-2 + NecromancerEntity.this.m_217043_().m_188503_(5), 1, -2 + NecromancerEntity.this.m_217043_().m_188503_(5));
                if (NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)NecromancerEntity.this.m_9236_(), (BlockPos)blockPos, EntityInit.WITHER_PUPPET)) {
                    ++spellCount;
                    WitherPuppetEntity puppet = (WitherPuppetEntity)EntityInit.WITHER_PUPPET.m_20615_((Level)serverWorld);
                    puppet.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(blockPos), MobSpawnType.EVENT, null, null);
                    puppet.m_20035_(blockPos, NecromancerEntity.this.m_9236_().m_213780_().m_188501_() * 360.0f, 0.0f);
                    puppet.setOwner((Mob)NecromancerEntity.this);
                    puppet.setLifeTicks(20 * (40 + NecromancerEntity.this.m_217043_().m_188503_(90)));
                    serverWorld.m_47205_((Entity)puppet);
                    int skeletonChance = NecromancerEntity.this.m_9236_().m_213780_().m_188503_(14);
                    if (skeletonChance == 0) {
                        WitherSkeleton witherSkeletonEntity = (WitherSkeleton)EntityType.f_20497_.m_20615_((Level)serverWorld);
                        witherSkeletonEntity.m_20035_(blockPos, NecromancerEntity.this.m_9236_().m_213780_().m_188501_() * 360.0f, 0.0f);
                        witherSkeletonEntity.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(blockPos), MobSpawnType.EVENT, null, null);
                        serverWorld.m_47205_((Entity)witherSkeletonEntity);
                    }
                }
                if (spellCount >= 3) break;
            }
        }

        @Override
        public SoundEvent getSoundPrepare() {
            return SoundEvents.f_11868_;
        }

        @Override
        public SpellCastingEntity.Spell getSpell() {
            return SpellCastingEntity.Spell.SUMMON_PUPPET;
        }
    }

    private class MagicWitheringGoal
    extends SpellCastingEntity.CastSpellGoal {
        private MagicWitheringGoal() {
            super(NecromancerEntity.this);
        }

        @Override
        public int getSpellTicks() {
            return 60;
        }

        @Override
        public int startTimeDelay() {
            return 60;
        }

        @Override
        public boolean m_8036_() {
            LivingEntity livingEntity = NecromancerEntity.this.m_5448_();
            if (!super.m_8036_()) {
                return false;
            }
            return NecromancerEntity.this.m_20280_((Entity)livingEntity) < 15.0 && NecromancerEntity.this.f_19797_ >= this.startTime;
        }

        @Override
        public void castSpell() {
            LivingEntity livingEntity = NecromancerEntity.this.m_5448_();
            if (livingEntity != null) {
                livingEntity.m_7292_(new MobEffectInstance(EffectInit.WITHERING, 180 + NecromancerEntity.this.m_9236_().m_213780_().m_188503_(5) * 20, 0));
                for (int i = 0; i < 60; ++i) {
                    double x = Mth.m_216263_((RandomSource)NecromancerEntity.this.m_9236_().m_213780_(), (double)(livingEntity.m_20191_().f_82288_ - 1.5), (double)livingEntity.m_20191_().f_82291_) + 1.5;
                    double y = Mth.m_216263_((RandomSource)NecromancerEntity.this.m_9236_().m_213780_(), (double)livingEntity.m_20191_().f_82289_, (double)livingEntity.m_20191_().f_82292_) + 1.0;
                    double z = Mth.m_216263_((RandomSource)NecromancerEntity.this.m_9236_().m_213780_(), (double)(livingEntity.m_20191_().f_82290_ - 1.5), (double)livingEntity.m_20191_().f_82293_) + 1.5;
                    ((ServerLevel)NecromancerEntity.this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }

        @Override
        public SoundEvent getSoundPrepare() {
            return SoundEvents.f_11868_;
        }

        @Override
        public SpellCastingEntity.Spell getSpell() {
            return SpellCastingEntity.Spell.SUMMON_PUPPET;
        }
    }
}

